<?php

namespace App\Http\Controllers\Crm\Blogs;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Support\Str;

class BlogsController extends Controller
{
    public function index(){
        $blogs = DB::table('blogs')
                    ->select('blogs.*','brands.name as brand_name', 'users.first_name as user_first_name','users.last_name as user_last_name')
                    ->leftjoin('brands','blogs.brand_id','brands.id')
                    ->leftjoin('users','blogs.user_id','users.id')
                    ->get();
        $brands = DB::table('brands')->get();
        return view('pages.blogs',compact('blogs','brands'));
    }
    
    
    // Blogs Post
    public function blogPost(Request $request){
    	$validate = $request->validate([
            'title' => 'required',
            'description' => 'required'
        ]);

    	$attachment = "";
        if($request->hasFile('file')){
            $file = $request->file('file');
            $attachment = uniqid().'.'.$file->guessExtension();
            $attachment_path = $file->move(public_path().'/backend/img/blogs/',$attachment);
        }else{
        	$attachment = "";
        }
        
        if(count($request->brandid) > 0){
            foreach($request->brandid as $row){
                $data = [
                	"title" => $request->title,
                	"slug" => Str::slug($request->title),
                	"description" => $request->description,
                	"meta_title" => $request->meta_title,
                	"meta_description" => $request->meta_description,
                	"image" => $attachment,
                	"brand_id" => $row,
                	"user_id" => session()->get('id'),
                ];
                DB::table('blogs')->insert($data);
            }
        }
        toastr()->success("Blog added successfully");
    	return redirect()->back();

        
        // if($insert){
        // 	toastr()->success("Blog added successfully");
        // 	return redirect()->back();
        // }else{
        // 	toastr()->error("Something went wrong");
        // 	return redirect()->back();
        // }
    }

    // Blog Edit
    public function blogEditPost(Request $request){
        $validate = $request->validate([
            'edit_title' => 'required',
            'edit_description' => 'required'
        ]);
        $attachment = "";
        if($request->hasFile('edit_file')){
            $file = $request->file('edit_file');
            $attachment = uniqid().'.'.$file->guessExtension();
            $attachment_path = $file->move(public_path().'/backend/img/blogs/',$attachment);
        }else{
            $get = DB::table('blogs')->where('id', $request->blog_id)->first();
            $attachment = $get->image;
        }

        $data = [
            "title" => $request->edit_title,
            "slug" => Str::slug($request->edit_title),
            "description" => $request->edit_description,
            "meta_title" => $request->edit_meta_title,
            "meta_description" => $request->edit_meta_description,
            "image" => $attachment,
            "brand_id" => $request->edit_brandid,
            "user_id" => session()->get('id'),
        ];
        $insert = DB::table('blogs')->where('id', $request->blog_id)->update($data);

        if($insert){
            toastr()->success("Blog updated successfully");
            return redirect()->back();
        }else{
            toastr()->error("Something went wrong");
            return redirect()->back();
        } 
    }

    // Blog Delete
    public function blogDelete(Request $request){
        $delete = DB::table('blogs')->where('id', $request->blog_id)->delete();
        if($delete){
            toastr()->success("Blog removed successfully");
            return redirect()->back();
        }else{
            toastr()->error("Something went wrong");
            return redirect()->back();
        }
    }
}